﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using MicroRWD.Common;
using MicroRWD.MFIC;

namespace MicroRWD.UI.MFIC
{
    public partial class MifareTabPanel : UserControl
    {
        DataPanel parent = null;
        public DataPanel Parent1
        {
            get { return parent; }
            set { parent = value; }
        }

        private ViewMode tab = ViewMode.NONE;
        public ViewMode Tab
        {
            get { return tab; }
            set
            {
                tab = value;

                if (parent != null)
                {
                    // Set the visible tab
                    switch (tab)
                    {
                        case ViewMode.CARD:
                            this.mifareTabControl.SelectTab(cardTabPage);
                            parent.FireActiveTabEvent(tab);
                            break;

                        case ViewMode.RWD_KEYS:
                            this.mifareTabControl.SelectTab(rwdKeysTabPage);
                            parent.FireActiveTabEvent(tab);
                            break;

                        case ViewMode.RWD_PARAMETERS:
                            this.mifareTabControl.SelectTab(rwdParamsTabPage);
                            parent.FireActiveTabEvent(tab);
                            break;

                        case ViewMode.NONE:
                            this.mifareTabControl.SelectTab(cardTabPage);
                            parent.FireActiveTabEvent(tab);
                            break;
                    }
                }
            }
        }
        
        public System.Windows.Forms.TabControl MifareTabControl
        {
            get { return mifareTabControl; }
            set { mifareTabControl = value; }
        }

        public MifareTabPanel()
        {
            InitializeComponent();
        }

        private void mifareTabControl_SelectedIndexChanged(object sender, EventArgs e)
        {
            // Set the visible tab
            if (this.mifareTabControl.SelectedTab == cardTabPage)
            {
                Tab = ViewMode.CARD;
            }
            else if (this.mifareTabControl.SelectedTab == rwdKeysTabPage)
            {
                Tab = ViewMode.RWD_KEYS;
            }
            else if (this.mifareTabControl.SelectedTab == rwdParamsTabPage)
            {
                Tab = ViewMode.RWD_PARAMETERS;
            }
        }
    }
}
